unit Maptest;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Menus, Pyrolab, StdCtrls, ExtCtrls, Ohmap, Forms, Dialogs, Ohmstuff,
  Tilesize;


type
  TMapEditor = class(TForm)
    VerticalScroll: TScrollBar;
    HorizontalScroll: TScrollBar;
    IconListBox: TListBox;
    ResizeButton: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N2: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    Open1: TMenuItem;
    New1: TMenuItem;
    Label5: TLabel;
    OpenMap1: TMenuItem;
    IconDisplay: TImage;
    Bevel1: TBevel;
    IconSetLabel: TLabel;
    OpenMapDialog: TOpenDialog;
    OpenSetDialog: TOpenDialog;
    FillButton: TButton;
    SaveMapDialog: TSaveDialog;
    UpButton: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Panel2: TPanel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    YposInd: TEdit;
    ZposInd: TEdit;
    XSizeInd: TPyroLabel;
    YSizeInd: TPyroLabel;
    ZSizeInd: TPyroLabel;
    XposInd: TEdit;
    TileNamePanel: TPanel;
    CursXPanel: TPanel;
    CursYPanel: TPanel;
    DownButton: TButton;
    MapDisplay: TOverHeadMap;
    Edit1: TMenuItem;
    ChangeTileSize1: TMenuItem;
    procedure doinit(Sender: TObject);
    procedure cleanup(Sender: TObject; var Action: TCloseAction);
    procedure ResizeButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure movemapx(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure movemapy(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure OpenMap1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure UpdateDisplay;
    procedure Togglecontrols;
    procedure Exit1Click(Sender: TObject);
    procedure UpdateImage(Sender: TObject);
    procedure FillButtonClick(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAsClick(Sender: TObject);
    procedure DragAssignTile(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure UpButtonClick(Sender: TObject);
    procedure AssignTile(Sender: TObject);
    procedure mapenter(Sender: TObject; var Key: Char);
    procedure movemap(Sender: TObject);
    procedure DisplayTileInfo(x,y,z:Integer);
    procedure DownButtonClick(Sender: TObject);
    procedure MapDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure DoDeDrop(Sender, Source: TObject; X, Y: Integer);
    procedure DragButtonUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ChangeTileSize1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  function GetFileName(name:string):string;

var
  MapEditor: TMapEditor;
  xdim,ydim,zdim,xoffs,yoffs,zoffs,lastx,lasty,lastz:Integer;
  loadedfile:string;
  draggedtile:Integer;
  blocklist:TBlockDefList;

implementation

uses
    Sizemap,Resize;

{$R *.DFM}

function GetFileName(name:string):String;
var
a:Integer;
begin
     a:=Pos('.',name);
     result:=Copy(name,0,a-1);
end;

{
 This procedure initializes all the stuff..
}
procedure TMapEditor.doinit(Sender: TObject);
begin
     blocklist:=TBlockDefList.Create;
     IconDisplay.Picture:=TPicture.create;
end;

procedure TMapEditor.cleanup(Sender: TObject; var Action: TCloseAction);
begin
     if Assigned(blocklist) then
        blocklist.free;
end;

procedure TMapEditor.ResizeButtonClick(Sender: TObject);
var
newmap:TOHMap;
x,y,z:Integer;
begin
     if ResizeDlg.Showmodal=mrOk then begin
        newmap:=TOHMap.Create(xdim,ydim,zdim);
        with mapdisplay.map do begin
             tilenamepanel.caption:='Please wait...';
             for x:=0 to xdim do begin
                 for y:=0 to ydim do begin
                     for z:=0 to zdim do begin
                         newmap.seticonat(x,y,z,0);
                     end;
                 end;
             end;
             for x:=xoffs to xdim do begin
                 for y:=yoffs to ydim do begin
                     for z:=zoffs to zdim do begin
                         newmap.seticonat(x,y,z,iconat(x-xoffs,y-yoffs,z-zoffs));
                     end;
                 end;
             end;
        end;
        Mapdisplay.map.free;
        Mapdisplay.map:=newmap;
        UpdateDisplay;
        Mapdisplay.Paint;

     end;
end;

procedure TMapEditor.FormCreate(Sender: TObject);
var
dispx,dispy:Integer;
begin

     dispx:=width div MapDisplay.tilexdim;
     dispy:=height div MapDisplay.tileydim;

     HorizontalScroll.SetParams(0,0,0);
     HorizontalScroll.largechange:=(MapDisplay.width div Mapdisplay.tilexdim)-1;

     VerticalScroll.SetParams(0,0,0);
     VerticalScroll.largechange:=(MapDisplay.height div Mapdisplay.tileydim)-1;
end;

procedure TMapEditor.movemapx(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
begin
     Mapdisplay.xpos:=ScrollPos;
     UpdateDisplay;
end;

procedure TMapEditor.movemapy(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
     Mapdisplay.ypos:=ScrollPos;
     UpdateDisplay;
end;

procedure TMapEditor.OpenMap1Click(Sender: TObject);
var
lc:Integer;
begin
     OpenMapDialog.Execute;
     if OpenMapDialog.filename<>'' then begin
        try
           if MapDisplay.Map<>nil then
              MapDisplay.Map.Free;
           MapDisplay.Map:=TOHMap.Create(0,0,0);
           MapDisplay.Map.Loadfromfile(openmapdialog.filename);

           lc:=(MapDisplay.width div Mapdisplay.tilexdim)-1;
           HorizontalScroll.SetParams(0,0,mapdisplay.map.xdim-lc);
           HorizontalScroll.largechange:=lc;
           lc:=(MapDisplay.height div Mapdisplay.tileydim)-1;
           VerticalScroll.SetParams(0,0,mapdisplay.map.ydim-lc);
           VerticalScroll.largechange:=lc;

           UpdateDisplay;
           MapDisplay.Paint;
           ToggleControls;
        except
              on EFOpenError do
                 Application.Messagebox('Unable to open file.','File Error',0);
        end;
     end;
end;

procedure TMapEditor.Open1Click(Sender: TObject);
var
a:Integer;
name:String;
begin
     OpenSetDialog.execute;
     if OpenSetDialog.filename<>'' then begin
        try
           if MapDisplay.Iconset[1]<>nil then
              MapDisplay.Iconset[1].free;
           MapDisplay.Iconset[1]:=TMapIconList.Create;
           MapDisplay.Iconset[1].loadfromfile(OpenSetDialog.filename);
           name:=GetFileName(OpenSetDialog.filename)+'.blk';
           IconListBox.Items.Clear;
           {Load in the block definitions}
           if FileExists(name) then begin
              blocklist.loadfromfile(name);
              for a:=0 to blocklist.count-1 do
                  Iconlistbox.items.add('BLOCK: '+TBlockDefinition(blocklist.items[a]).name);
           end;

           for a:=0 to MapDisplay.IconSet[1].Count-1 do
               IconListBox.Items.Add(TMapIcon(MapDisplay.Iconset[1].Items[a]).Name);

           IconSetLabel.Caption:=ExtractFileName(OpenSetDialog.Filename);
           UpdateDisplay;
           MapDisplay.tilexdim:=TMapIcon(Mapdisplay.iconset[1].items[0]).image.width;
           MapDisplay.tileydim:=TMapIcon(Mapdisplay.iconset[1].items[0]).image.height;
           MapDisplay.Paint;
           ToggleControls;
        except
              on E:EFOpenError do begin
                 MapDisplay.Iconset[1].free;
                 MapDisplay.Iconset[1]:=nil;
                 Application.ShowException(E);
              end;
              on E:EReadError do begin
                 MapDisplay.Iconset[1].free;
                 MapDisplay.Iconset[1]:=nil;
                 Application.ShowException(E);
              end;
        end;
     end;
end;

procedure TMapEditor.New1Click(Sender: TObject);
var
x,y,z,lc:Integer;
begin
     if loadedfile<>'' then begin
        if Application.Messagebox('Save current map first?','Well?',mb_YesNo)=IDYES then
           Save1Click(Sender);
     end;
     if Sizeform.Showmodal<>mrCancel then begin
        if MapDisplay.Map<>nil then
           MapDisplay.Map.Free;
        MapDisplay.Map:=TOHMap.Create(xdim,ydim,zdim);
        for x:=0 to xdim do begin
            for y:=0 to ydim do begin
                for z:=0 to zdim do begin
                    MapDisplay.Map.seticonat(x,y,z,0);
                end;
            end;
        end;

        lc:=(MapDisplay.width div Mapdisplay.tilexdim)-1;
        if mapdisplay.map.xdim>(lc+1) then begin
           HorizontalScroll.SetParams(0,0,mapdisplay.map.xdim-lc);
           HorizontalScroll.largechange:=lc;
        end
        else
            Horizontalscroll.enabled:=false;

        lc:=(MapDisplay.height div Mapdisplay.tileydim)-1;
        if mapdisplay.map.ydim>(lc+1) then begin
           VerticalScroll.SetParams(0,0,mapdisplay.map.ydim-lc);
           VerticalScroll.largechange:=lc;
        end
        else
            VerticalScroll.enabled:=false;

        {Set loaded file to nothing..}
        loadedfile:='';

        UpdateDisplay;
        MapDisplay.Paint;
        ToggleControls;
     end;
end;

procedure TMapEditor.UpdateDisplay;
begin
     with MapDisplay do begin
          if map<>nil then begin
             XSizeInd.Number:=Map.Xdim;
             YSizeInd.Number:=Map.Ydim;
             ZSizeInd.Number:=Map.Zdim;
          end;
          XPosInd.Text:=IntToStr(XPos);
          YPosInd.Text:=IntToStr(YPos);
          ZPosInd.Text:=IntToStr(ZPos);
     end;
end;

procedure TMapEditor.Togglecontrols;
begin
     if MapDisplay.Iconset[1]<>nil then begin
          if MapDisplay.Map<>nil then begin
               HorizontalScroll.Enabled:=True;
               VerticalScroll.Enabled:=True;
               ReSizeButton.Enabled:=True;
               FillButton.Enabled:=True;
               Save1.Enabled:=True;
               SaveAs1.Enabled:=True;
               XPosInd.Enabled:=True;
               YPosInd.Enabled:=True;
               ZPosInd.Enabled:=True;
               UpButton.Enabled:=True;
               DownButton.Enabled:=True;
          end
          else begin
               HorizontalScroll.Enabled:=False;
               VerticalScroll.Enabled:=False;
               ReSizeButton.Enabled:=False;
               FillButton.Enabled:=False;
               Save1.Enabled:=False;
               SaveAs1.Enabled:=False;
               XPosInd.Enabled:=False;
               YPosInd.Enabled:=False;
               ZPosInd.Enabled:=False;
               UpButton.Enabled:=True;
               DownButton.Enabled:=True;
          end;
          IconListBox.Enabled:=True;
     end
     else begin
          IconListBox.Enabled:=False;
          if MapDisplay.Map<>nil then begin
             Save1.Enabled:=True;
             SaveAs1.Enabled:=True;
          end
          else begin
              Save1.Enabled:=False;
              SaveAs1.Enabled:=False;
          end;
     end;

end;


procedure TMapEditor.Exit1Click(Sender: TObject);
begin
     Application.Terminate;
end;

procedure TMapEditor.UpdateImage(Sender: TObject);
begin
     if blocklist.count>0 then begin
        if iconlistbox.itemindex>=blocklist.count then
           IconDisplay.Picture.Bitmap:=TMapIcon(MapDisplay.Iconset[1].Items[IconListBox.ItemIndex-blocklist.count]).Image
        else if IconDisplay.Picture<>nil then
            IconDisplay.Picture:=nil;
     end
     else if iconlistbox.itemindex>-1 then
          IconDisplay.Picture.Bitmap:=TMapIcon(MapDisplay.Iconset[1].Items[Iconlistbox.itemindex]).image;
end;

procedure TMapEditor.DragAssignTile(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);

begin
     with MapDisplay do begin
          if ready then begin
             x:=XMapcoord(x) ; y:=YMapCoord(y) ;
             if (lastx<>X) or (lasty<>y) or (lastz<>Zpos) then begin

                if (ssRight in Shift) and (dragging=false) then begin
                   draggedtile:=map.iconat(x,y,zpos);
                   MapDisplay.BeginDrag(false);
                   Exit;
                end;

                If (ssLeft in Shift) then begin
                   Selected.X:=x;
                   Selected.Y:=y;
                   Selected.Shift:=Shift;
                   AssignTile(Sender);
                end
                else
                     DisplayTileInfo(x,y,Zpos);
             end;
          end;
     end;
end;

procedure TMapEditor.AssignTile(Sender: TObject);
var
x,y,a,b,ii:Integer;
shift:TShiftState;
block:TBlockDefinition;
begin
     with mapdisplay do begin
          if ready then begin
             X:=Selected.X; Y:=Selected.Y; Shift:=Selected.Shift;
             if ssCtrl in shift then begin
                if blocklist.count>0 then
                   IconListBox.Itemindex:=Map.IconAt(X,Y,Zpos)+blocklist.count
                else
                    IconListBox.Itemindex:=Map.IconAt(X,Y,Zpos);
                UpdateImage(Sender);
             end
             else if ssShift in shift then begin
               if TMapIcon(Iconset[1].Items[Map.Iconat(X,Y,Zpos)]).alternate>-1 then begin
                  Map.SetIconAt(X,Y,Zpos,Iconset[1].IconIndex(TMapIcon(Iconset[1].Items[Map.Iconat(X,Y,Zpos)]).alternate));
                  Redraw(X,Y,ZPos,-1);
               end;
             end
          else begin
              ii:=IconListBox.ItemIndex;
              if (ready) and (ii>-1) then begin
                 if ii<blocklist.count then begin
                    block:=TBlockDefinition(blocklist.items[ii]);
                    for a:=0 to block.xsize-1 do
                        for b:=0 to block.ysize-1 do
                            Map.SetIconAt(X+a,Y+b,Zpos,Block.GetIconAt(a,b));
                    Paint;
                    lastx:=x; lasty:=y; lastz:=zpos;
                 end
                 else begin
                      if blocklist.count>0 then
                         ii:=ii-blocklist.count;
                      Map.SetIconAt(X,Y,ZPos,ii);
                      Redraw(X,Y,ZPos,-1);
                      lastx:=X;
                      lasty:=Y;
                      lastz:=ZPos;
                 end;
              end;
          end;
        end;
     end;
end;


procedure TMapEditor.Save1Click(Sender: TObject);
begin
     if MapDisplay.Map<>nil then begin
        if loadedfile<>'' then begin
           MapDisplay.Map.SaveToFile(loadedfile);
        end
        else
            SaveAsClick(Sender);
     end;
end;

procedure TMapEditor.SaveAsClick(Sender: TObject);
begin
     if MapDisplay.map<>nil then begin
        try
           SaveMapDialog.Execute;
           If SaveMapDialog.Filename<>'' then begin
              try
                 MapDisplay.Map.SaveToFile(SaveMapDialog.Filename);
                 loadedfile:=SaveMapDialog.Filename;
              except
                 on EFCreateError do Application.MessageBox('Unable to save map file.','File Save Error',0);
              end;
           end;
        except
           on EFCreateError do Application.MessageBox('Unable to save map file.','File Save Error',0);
        end;
     end;
end;

procedure TMapEditor.UpButtonClick(Sender: TObject);
begin
     if MapDisplay.ready then begin
        if MapDisplay.Zpos<MapDisplay.Map.Zdim-1 then begin
           MapDisplay.Zpos:=MapDisplay.Zpos+1;
           UpdateDisplay;
           MapDisplay.Paint;
        end
        else
            MessageBeep($ffff);
     end;
end;

procedure TMapEditor.DownButtonClick(Sender: TObject);
begin
     if MapDisplay.ready then begin
        if MapDisplay.Zpos>0 then begin
           MapDisplay.Zpos:=MapDisplay.Zpos-1;
           UpdateDisplay;
           MapDisplay.Paint;
        end
        else
            MessageBeep($ffff);
     end;
end;

procedure TMapEditor.FillButtonClick(Sender: TObject);
var
   x,y:Integer;
begin
     with MapDisplay do begin
          for x:=0 to Map.xdim do begin
              for y:=0 to map.ydim do begin
                  Map.SetIconAt(x,y,MapDisplay.zpos,IconListBox.ItemIndex);
              end;
          end;
          Paint;
     end;
end;


procedure TMapEditor.mapenter(Sender: TObject; var Key: Char);
begin
     if key=Char(13) then key:=Char(9);
end;

procedure TMapEditor.movemap(Sender: TObject);
begin
     MapDisplay.SetMapCoords(StrToInt(XposInd.Text),StrToInt(YPosInd.Text),StrToInt(ZposInd.text));
     HorizontalScroll.Setparams(Mapdisplay.xpos,0,Mapdisplay.map.xdim);
     VerticalScroll.Setparams(Mapdisplay.ypos,0,Mapdisplay.map.ydim);
     UpdateDisplay;
end;

procedure TMapEditor.DisplayTileInfo(x,y,z:Integer);
begin
     with mapdisplay do begin
          Tilenamepanel.caption:=TMapIcon(Iconset[1].items[Map.iconat(x,y,z)]).name;
          cursxpanel.caption:='CursX: '+IntToStr(x);
          cursypanel.caption:='CursY: '+IntToStr(y);
    end;
end;


procedure TMapEditor.MapDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
     if (source is TOverHeadMap) or ((source is TListBox) and (TControl(source).tag=42)) then
        Accept:=True
     else
         Accept:=False;

end;

procedure TMapEditor.DoDeDrop(Sender, Source: TObject; X, Y: Integer);
begin
     with MapDisplay do begin
          Map.SetIconAt(XMapcoord(x),YMapCoord(y),Zpos,draggedtile);
          Paint;
     end;
end;

procedure TMapEditor.DragButtonUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     if (Mapdisplay.Dragging) then
        Mapdisplay.EndDrag(true);
end;

procedure TMapEditor.ChangeTileSize1Click(Sender: TObject);
begin
     if tilesizedlg.Showmodal=mrOk then begin
        MapDisplay.tilexdim:=xdim;
        MapDisplay.tileydim:=ydim;
        Mapdisplay.paint;
     end;
end;

end.
